-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Oct 30, 2025 at 11:54 AM
-- Server version: 9.1.0
-- PHP Version: 8.2.26

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `mpay`
--

-- --------------------------------------------------------

--
-- Table structure for table `otp_requests`
--

DROP TABLE IF EXISTS `otp_requests`;
CREATE TABLE IF NOT EXISTS `otp_requests` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `otp_code` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `type` enum('password','pin') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` enum('unused','used','expired') COLLATE utf8mb4_general_ci DEFAULT 'unused',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `plans`
--

DROP TABLE IF EXISTS `plans`;
CREATE TABLE IF NOT EXISTS `plans` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `referral_bonus` decimal(10,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_general_ci,
  `status` enum('active','inactive','','') COLLATE utf8mb4_general_ci DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `plans`
--

INSERT INTO `plans` (`id`, `name`, `price`, `referral_bonus`, `description`, `status`, `created_at`) VALUES
(1, 'Starter Plan', 5000.00, 50.00, 'Beginner plan with small rewards.', 'active', '2025-08-26 23:56:39'),
(2, 'Pro Plan', 15000.00, 150.00, 'Intermediate plan with higher rewards.', 'active', '2025-08-26 23:56:39'),
(3, 'Elite Plan', 50000.00, 500.00, 'Premium plan with maximum rewards.', 'active', '2025-08-26 23:56:39'),
(4, 'Mini Plan', 3000.00, 30.00, 'Beginner friendly with very small rewards.\r\n', 'active', '2025-08-31 11:49:55'),
(5, 'Business Plan', 10000.00, 100.00, 'Well balanced plan with very good rewards.\n', 'active', '2025-09-06 00:01:23'),
(6, 'Expert Plan', 20000.00, 200.00, 'Level up your finance like an expert', 'active', '2025-09-06 00:01:23');

-- --------------------------------------------------------

--
-- Table structure for table `plan_powers`
--

DROP TABLE IF EXISTS `plan_powers`;
CREATE TABLE IF NOT EXISTS `plan_powers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `plan_id` int DEFAULT NULL,
  `power_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `min_value` int DEFAULT NULL,
  `reward` decimal(10,2) DEFAULT NULL,
  `duration` varchar(200) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '24',
  `status` enum('active','inactive','','') COLLATE utf8mb4_general_ci DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `plan_powers`
--

INSERT INTO `plan_powers` (`id`, `plan_id`, `power_name`, `min_value`, `reward`, `duration`, `status`, `created_at`) VALUES
(1, 1, 'Starter Power 1', 80, 500.00, '24', 'active', '2025-08-26 23:58:41'),
(3, 2, 'Pro Power 1', 200, 1500.00, '24', 'active', '2025-08-26 23:58:41'),
(5, 3, 'Elite Power 1', 30, 5000.00, '24', 'active', '2025-08-26 23:58:41'),
(7, 4, 'Mini Plan', 50, 300.00, '24', 'active', '2025-08-31 11:51:00'),
(8, 5, 'Business Plan\r\n', 500, 1000.00, '24', 'active', '2025-09-06 00:03:55'),
(9, 6, 'Expert Plan', 300, 2000.00, '24', 'active', '2025-09-06 00:03:55');

-- --------------------------------------------------------

--
-- Table structure for table `power_activations`
--

DROP TABLE IF EXISTS `power_activations`;
CREATE TABLE IF NOT EXISTS `power_activations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `plan_power_id` int DEFAULT NULL,
  `reward` decimal(10,2) DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `started_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `duration` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `end_time` varchar(200) COLLATE utf8mb4_general_ci NOT NULL,
  `completed_at` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `power_activations`
--

INSERT INTO `power_activations` (`id`, `user_id`, `plan_power_id`, `reward`, `status`, `created_at`, `started_at`, `duration`, `end_time`, `completed_at`) VALUES
(1, 3, 5, 6000.00, 'completed', '2025-08-30 12:32:55', '2025-08-29 12:32:55', '24', '2025-08-30 14:32:55', '2025-08-30 08:53:19'),
(2, 3, 5, 6000.00, 'completed', '2025-08-30 12:53:19', '2025-08-30 18:53:19', '', '2025-08-29 14:53:19', '2025-08-30 08:54:23'),
(3, 3, 5, 6000.00, 'completed', '2025-08-30 12:54:23', '2025-08-29 18:54:23', '', '2025-08-30 14:54:23', '2025-08-30 09:03:13'),
(4, 3, 3, 1800.00, 'completed', '2025-08-30 12:57:22', '2025-08-29 12:57:22', '24', '2025-08-30 14:57:22', '2025-08-30 08:58:03'),
(5, 3, 3, 1800.00, 'completed', '2025-08-30 12:58:03', '2025-08-30 18:58:03', '', '2025-08-31 14:58:03', '2025-09-06 00:55:03'),
(7, 3, 5, 6000.00, 'completed', '2025-08-30 13:03:13', '2025-08-29 19:03:13', '', '2025-08-30 15:03:13', '2025-08-30 09:08:05'),
(9, 3, 5, 6000.00, 'completed', '2025-08-30 13:08:05', '2025-08-30 19:08:05', '', '2025-08-31 15:08:05', '2025-09-06 00:55:02'),
(10, 3, 1, 500.00, 'completed', '2025-08-31 08:24:48', '2025-08-31 08:24:48', '24', '2025-09-01 10:24:48', '2025-09-06 00:55:01'),
(11, 4, 1, 500.00, 'completed', '2025-08-31 10:32:09', '2025-08-30 10:32:09', '24', '2025-08-31 10:35:09', '2025-08-31 11:38:28'),
(12, 4, 1, 500.00, 'completed', '2025-08-31 10:38:28', '2025-08-31 09:38:28', '', '2025-08-10 10:38:28', '2025-08-31 11:51:41'),
(13, NULL, NULL, NULL, 'active', '2025-08-31 10:38:28', '2025-08-31 09:38:28', '', '1970-01-01 00:00:00', NULL),
(14, 4, 1, 500.00, 'completed', '2025-08-31 10:51:41', '2025-08-31 09:51:41', '', '2025-08-01 10:51:41', '2025-08-31 12:10:00'),
(15, NULL, NULL, NULL, 'active', '2025-08-31 10:51:41', '2025-08-31 09:51:41', '', '1970-01-01 00:00:00', NULL),
(16, 4, 1, 500.00, 'completed', '2025-08-31 11:10:00', '2025-08-31 10:10:00', '', '2025-08-01 11:10:00', '2025-08-31 12:15:28'),
(17, NULL, NULL, NULL, 'active', '2025-08-31 11:10:00', '2025-08-31 10:10:00', '', '1970-01-01 00:00:00', NULL),
(18, 4, 1, 500.00, 'completed', '2025-08-31 11:15:28', '2025-08-31 10:15:28', '', '2025-09-01 11:15:28', '2025-10-10 09:38:10'),
(19, 5, 7, 300.00, 'completed', '2025-08-31 11:56:17', '2025-08-31 11:56:17', '24', '2025-08-01 11:56:17', '2025-08-31 12:58:30'),
(20, 5, 7, 300.00, 'active', '2025-08-31 11:58:30', '2025-08-31 10:58:30', '', '2025-09-01 11:58:30', NULL),
(21, 3, 1, 500.00, 'completed', '2025-09-05 23:55:01', '2025-09-05 22:55:01', '', '2025-09-06 23:55:01', '2025-10-29 13:50:48'),
(22, 3, 5, 6000.00, 'completed', '2025-09-05 23:55:02', '2025-09-05 22:55:02', '', '2025-09-06 23:55:02', '2025-10-29 13:50:49'),
(23, 3, 3, 1800.00, 'active', '2025-09-05 23:55:03', '2025-09-05 22:55:03', '', '2025-09-06 23:55:03', NULL),
(24, 4, 1, 500.00, 'completed', '2025-10-10 08:38:10', '2025-10-10 07:38:10', '', '2025-10-11 08:38:10', '2025-10-30 12:52:04'),
(25, 3, 7, 300.00, 'completed', '2025-10-10 15:16:11', '2025-10-10 15:16:11', '24', '2025-10-11 15:16:11', '2025-10-29 13:50:52'),
(26, 3, 1, 500.00, 'active', '2025-10-29 12:50:48', '2025-10-29 11:50:48', '', '2025-10-30 12:50:48', NULL),
(27, 3, 5, 6000.00, 'active', '2025-10-29 12:50:49', '2025-10-29 11:50:49', '', '2025-10-30 12:50:49', NULL),
(28, 3, 7, 300.00, 'active', '2025-10-29 12:50:52', '2025-10-29 11:50:52', '', '2025-10-30 12:50:52', NULL),
(29, 4, 1, 500.00, 'active', '2025-10-30 11:52:04', '2025-10-30 10:52:04', '', '2025-10-31 11:52:04', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
CREATE TABLE IF NOT EXISTS `purchases` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `plan_id` int DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `status` enum('active','expired') COLLATE utf8mb4_general_ci DEFAULT 'active',
  `started_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `referral_earnings`
--

DROP TABLE IF EXISTS `referral_earnings`;
CREATE TABLE IF NOT EXISTS `referral_earnings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `referred_user_id` int DEFAULT NULL,
  `plan_id` int DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `referral_earnings`
--

INSERT INTO `referral_earnings` (`id`, `user_id`, `referred_user_id`, `plan_id`, `amount`, `created_at`) VALUES
(1, 3, 4, 1, 25.00, '2025-08-31 11:10:00'),
(2, 3, 4, 1, 250.00, '2025-08-31 11:15:28'),
(3, 3, 5, 7, 30.00, '2025-08-31 11:58:30'),
(4, 3, 4, 1, 50.00, '2025-10-10 08:38:10'),
(5, 3, 4, 1, 50.00, '2025-10-30 11:52:04');

-- --------------------------------------------------------

--
-- Table structure for table `site_info`
--

DROP TABLE IF EXISTS `site_info`;
CREATE TABLE IF NOT EXISTS `site_info` (
  `id` int NOT NULL AUTO_INCREMENT,
  `site_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `site_email` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `site_phone` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_general_ci DEFAULT 'USD',
  `min_withdrawal` decimal(10,2) DEFAULT '10.00',
  `referral_percentage` decimal(5,2) DEFAULT '10.00',
  `about_us` text COLLATE utf8mb4_general_ci,
  `terms` text COLLATE utf8mb4_general_ci,
  `privacy_policy` text COLLATE utf8mb4_general_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `bank` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'Opay',
  `account_name` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'John David Okpe',
  `account_number` varchar(255) COLLATE utf8mb4_general_ci DEFAULT '8135356363',
  `pay_pubkey` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'pk_live_4fe0ad3d889d94565a4dcc3dd3ea10b9254dc17b',
  `pay_seckey` varchar(255) COLLATE utf8mb4_general_ci DEFAULT 'sk_live_9f7b45266ddc1caf451a6fb6a1df93306b97b57d',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `site_info`
--

INSERT INTO `site_info` (`id`, `site_name`, `site_email`, `site_phone`, `currency`, `min_withdrawal`, `referral_percentage`, `about_us`, `terms`, `privacy_policy`, `created_at`, `bank`, `account_name`, `account_number`, `pay_pubkey`, `pay_seckey`) VALUES
(1, 'mPay', 'support@mpay.online', '+2348109145471', '₦', 2000.00, 10.00, NULL, NULL, NULL, '2025-08-26 23:45:16', 'Opay', 'Okpe John ', '9060779975', 'pk_live_4fe0ad3d889d94565a4dcc3dd3ea10b9254dc17b', 'sk_live_9f7b45266ddc1caf451a6fb6a1df93306b97b57d');

-- --------------------------------------------------------

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
CREATE TABLE IF NOT EXISTS `transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `type` enum('deposit','purchase','referral','activation','withdrawal','adjustment') COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reference` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `status` enum('pending','success','failed') COLLATE utf8mb4_general_ci DEFAULT 'success',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `transactions`
--

INSERT INTO `transactions` (`id`, `user_id`, `type`, `reference`, `amount`, `status`, `created_at`) VALUES
(1, 3, 'deposit', 'DEP-1756261238-21BD4A', 500.00, 'success', '2025-08-27 02:24:24'),
(2, 3, 'deposit', 'DEP-1756331184-653CA2', 10000.00, 'success', '2025-08-27 21:46:24'),
(3, 3, 'deposit', '0', 10000.00, 'success', '2025-08-27 21:53:39'),
(4, 3, 'deposit', NULL, NULL, 'success', '2025-08-30 10:12:32'),
(5, 3, 'purchase', '2e2ed6bdd453a5f04998d96c76250fa8', 15000.00, 'success', '2025-08-30 10:33:43'),
(6, 3, 'purchase', '24804adadf378d86013b3bc41c92a870', 15000.00, 'success', '2025-08-30 10:46:41'),
(7, 3, 'purchase', '3b3dbb7b14d3f5c260da772ad4b5fe43', 15000.00, 'success', '2025-08-30 11:14:11'),
(8, 3, 'purchase', '898eed1de820ef070f7b14a272c6b181', 15000.00, 'success', '2025-08-30 11:14:27'),
(9, 3, 'purchase', '4c1e7d57c5f6148eadef06ee3c79bafc', 50000.00, 'success', '2025-08-30 11:20:41'),
(10, 3, 'activation', 'a0fbb4504a716cd4be7dfd39ea91326b', 6000.00, 'success', '2025-08-30 12:38:12'),
(11, 3, 'activation', 'ab094885a0c1e4db145813c590ef4fe1', 6000.00, 'success', '2025-08-30 12:53:19'),
(12, 3, 'activation', 'd5c999561f48b0d34fa5fdaf3a1166a4', 6000.00, 'success', '2025-08-30 12:54:23'),
(13, 3, 'activation', '583a18f2039bfd01b4043c2f92c5d631', 1800.00, 'success', '2025-08-30 12:58:03'),
(14, NULL, 'activation', '9ddf4d3abcc0fa287fe74101d81a0de1', NULL, 'success', '2025-08-30 12:58:03'),
(15, 3, 'activation', '0510cbe91929590f1a8d3addf0b83ea5', 6000.00, 'success', '2025-08-30 13:03:13'),
(16, NULL, 'activation', '5047654aa32a35596b6ebd34cc093735', NULL, 'success', '2025-08-30 13:03:13'),
(20, 3, 'activation', '422df3aad4d7111e474c5dc6f2201804', 6000.00, 'success', '2025-08-30 13:08:05'),
(21, 3, 'withdrawal', 'WD-68b325b049733', 10000.00, 'pending', '2025-08-30 16:24:16'),
(22, 3, 'withdrawal', 'WD-68b3273ce3291', 10000.00, 'pending', '2025-08-30 16:30:52'),
(23, 3, 'withdrawal', 'WD-68b329ab058c8', 1000.00, 'pending', '2025-08-30 16:41:15'),
(24, 3, 'purchase', '2c8e1cd44634da44c945c4dc534665b6', 5000.00, 'success', '2025-08-31 08:24:06'),
(25, 4, 'deposit', '0', 50000.00, 'success', '2025-08-31 10:31:27'),
(26, 4, 'purchase', '429db418f2d777688bdd2fdc126b6d33', 5000.00, 'success', '2025-08-31 10:31:56'),
(27, 4, 'activation', 'bb9723cae9627f1ecfd7c4458d7f34c4', 500.00, 'success', '2025-08-31 10:38:28'),
(28, NULL, 'activation', 'e335c5d2e7112596466c99a1df52f564', NULL, 'success', '2025-08-31 10:38:28'),
(29, 4, 'activation', '1e928b0e2260567c241a2c2cc2080edf', 500.00, 'success', '2025-08-31 10:51:41'),
(30, NULL, 'activation', '25f875757dfa05cbbcfb3b108e3db116', NULL, 'success', '2025-08-31 10:51:41'),
(31, 4, 'activation', 'e0886442d2673e544b836ce44d207b95', 500.00, 'success', '2025-08-31 11:10:00'),
(32, 3, 'referral', '2f9e133fe55efd27d907edfdb7bfba4a', 25.00, 'success', '2025-08-31 11:10:00'),
(33, NULL, 'activation', '89b4ce2a88af173018617b44a28a9dbb', NULL, 'success', '2025-08-31 11:10:00'),
(34, 4, 'activation', '818ad62e5c86f9a5a4729127745a6b7d', 500.00, 'success', '2025-08-31 11:15:28'),
(35, 3, 'referral', '649dd5d79f30a386f4c5e85ff4e6ef3d', 250.00, 'success', '2025-08-31 11:15:28'),
(36, 4, 'withdrawal', 'WD-68b43052e73e4', 1000.00, 'pending', '2025-08-31 11:21:54'),
(37, 5, 'deposit', '0', 2000.00, 'success', '2025-08-31 11:46:12'),
(38, 5, 'deposit', '0', 1000.00, 'success', '2025-08-31 11:54:18'),
(39, 5, 'purchase', 'ced1e755083fc35473984a99ca1bdc32', 3000.00, 'success', '2025-08-31 11:55:54'),
(40, 5, 'activation', 'f9eee62c4c294978e7de88831ccb705a', 300.00, 'success', '2025-08-31 11:58:30'),
(41, 3, 'referral', '35abd5272237a9eff4fbcd352873600c', 30.00, 'success', '2025-08-31 11:58:30'),
(42, 3, 'deposit', '0', 600.00, 'success', '2025-09-05 23:45:51'),
(43, 3, 'deposit', 'DEP-1757116398747', 500.00, 'success', '2025-09-05 23:53:19'),
(44, 3, 'deposit', 'DEP-1757116439879', 455.00, 'success', '2025-09-05 23:54:39'),
(45, 3, 'activation', 'e39a3660f3b37a58a666ef9fe24110ee', 500.00, 'success', '2025-09-05 23:55:01'),
(46, 3, 'activation', '8167e833ac13124447719b34bd5a1adf', 6000.00, 'success', '2025-09-05 23:55:02'),
(47, 3, 'activation', 'bfe19abd2bb4cf6e9380c51f707d87f6', 1800.00, 'success', '2025-09-05 23:55:03'),
(48, 4, 'activation', 'df310d4e2c89c896896b3eeb5e9fdb81', 500.00, 'success', '2025-10-10 08:38:10'),
(49, 3, 'referral', 'edc53b4ca3c4959ddf08d9af6bbdf9e2', 50.00, 'success', '2025-10-10 08:38:10'),
(50, 3, 'purchase', '6591d8dd11a508e7b087b0b8c4bc41e1', 3000.00, 'success', '2025-10-10 15:16:03'),
(51, 3, 'activation', 'ae49c563cfec608d6c1fac2410a7476e', 500.00, 'success', '2025-10-29 12:50:48'),
(52, 3, 'activation', 'ad820ebacb6d06eeedcc3cc397c17db3', 6000.00, 'success', '2025-10-29 12:50:49'),
(53, 3, 'activation', '530c98050b3ba284f4fa9643224f6e5e', 300.00, 'success', '2025-10-29 12:50:52'),
(54, 4, 'activation', 'b06b2738cd07909e6b9e6d05edfeb1fd', 500.00, 'success', '2025-10-30 11:52:04'),
(55, 3, 'referral', '673f29b9c8b5d2baf2ad879dc90456b8', 50.00, 'success', '2025-10-30 11:52:04');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `fullname` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `pin` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `referral_code` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `referred_by` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `balance` decimal(10,2) DEFAULT '0.00',
  `withdrawable_balance` decimal(10,2) DEFAULT '0.00',
  `otp_code` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `otp_expires` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `fullname`, `email`, `phone`, `password`, `pin`, `referral_code`, `referred_by`, `balance`, `withdrawable_balance`, `otp_code`, `otp_expires`, `created_at`) VALUES
(3, 'John David Okpe', 'lordphp319@gmail.com', '09024388386', '$2y$10$Z634vRUmjiyr0rWstXvdPe5We6R8Q4Cwv9HCpyXSJ.arvgo3qohoa', '1234', 'E66E99B5', NULL, 3055.00, 26305.01, NULL, NULL, '2025-08-27 00:44:29'),
(4, 'Victor Okafor', 'okaffskido@gmail.com', '09014292469', '$2y$10$XD88kD4tSrD7STn0IoM6gek.XAtxbLHtYnRBfcjphE.GXkNEN/fmK', '1234', '021BF457', '3', 45000.00, 2000.00, NULL, NULL, '2025-08-30 18:41:08'),
(5, 'Janet Joel', 'janetjoe@gmail.com', '07044814722', '$2y$10$b.NdYjP3AFNrUKkGa48T.OxWz4LVRKENkp8dJeYk1iBcBkevXdiBC', '0704481', '07D93225', '3', 0.00, 300.00, NULL, NULL, '2025-08-31 11:43:17');

-- --------------------------------------------------------

--
-- Table structure for table `user_plans`
--

DROP TABLE IF EXISTS `user_plans`;
CREATE TABLE IF NOT EXISTS `user_plans` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `plan_id` int NOT NULL,
  `transaction_reference` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` enum('active','expired','cancelled') COLLATE utf8mb4_general_ci DEFAULT 'active',
  `purchased_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_plan_id` (`plan_id`),
  KEY `idx_status` (`status`),
  KEY `idx_expires_at` (`expires_at`),
  KEY `idx_user_plan_active` (`user_id`,`status`),
  KEY `idx_plan_active_users` (`plan_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `user_plans`
--

INSERT INTO `user_plans` (`id`, `user_id`, `plan_id`, `transaction_reference`, `status`, `purchased_at`, `expires_at`, `created_at`, `updated_at`) VALUES
(1, 3, 2, '24804adadf378d86013b3bc41c92a870', 'active', '2025-08-30 10:46:41', NULL, '2025-08-30 10:46:41', '2025-08-30 10:46:41'),
(4, 3, 3, '4c1e7d57c5f6148eadef06ee3c79bafc', 'active', '2025-08-30 11:20:41', NULL, '2025-08-30 11:20:41', '2025-08-30 11:20:41'),
(5, 3, 1, '2c8e1cd44634da44c945c4dc534665b6', 'active', '2025-08-31 08:24:06', NULL, '2025-08-31 08:24:06', '2025-08-31 08:24:06'),
(6, 4, 1, '429db418f2d777688bdd2fdc126b6d33', 'active', '2025-08-31 10:31:56', NULL, '2025-08-31 10:31:56', '2025-08-31 10:31:56'),
(7, 5, 4, 'ced1e755083fc35473984a99ca1bdc32', 'active', '2025-08-31 11:55:54', NULL, '2025-08-31 11:55:54', '2025-08-31 11:55:54'),
(8, 3, 4, '6591d8dd11a508e7b087b0b8c4bc41e1', 'active', '2025-10-10 15:16:03', NULL, '2025-10-10 15:16:03', '2025-10-10 15:16:03');

-- --------------------------------------------------------

--
-- Table structure for table `withdrawals`
--

DROP TABLE IF EXISTS `withdrawals`;
CREATE TABLE IF NOT EXISTS `withdrawals` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `status` enum('pending','approved','rejected') COLLATE utf8mb4_general_ci DEFAULT 'pending',
  `requested_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `processed_at` timestamp NULL DEFAULT NULL,
  `bank` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `account_number` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `withdrawals`
--

INSERT INTO `withdrawals` (`id`, `user_id`, `amount`, `status`, `requested_at`, `processed_at`, `bank`, `account`, `account_number`) VALUES
(1, 3, 10000.00, 'pending', '2025-08-30 16:24:16', NULL, 'UBA', 'John David Okpe', '454'),
(2, 3, 10000.00, 'pending', '2025-08-30 16:30:52', NULL, 'Fidelity Bank', 'John David Okpe', '8135356363'),
(3, 3, 1000.00, 'pending', '2025-08-30 16:41:15', NULL, 'Opay', 'John David Okpe', '8135356363'),
(4, 4, 1000.00, 'pending', '2025-08-31 11:21:54', NULL, 'Moniepoint', 'John David Okpe', '8135356363');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `user_plans`
--
ALTER TABLE `user_plans`
  ADD CONSTRAINT `user_plans_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_plans_ibfk_2` FOREIGN KEY (`plan_id`) REFERENCES `plans` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
